/**
 * 月々のつぶやき回数
 */
const monthlyArea = document.getElementById('monthly');
if (monthlyArea) {
  (async function() {
    new Chart(
      monthlyArea,
      {
        type: 'bar',
        data: {
          labels: monthlyData.map(row => row.date),
          datasets: [
            {
              label: '月々のつぶやき回数',
              data: monthlyData.map(row => row.count),
              backgroundColor: monthlyBarColor
            }
          ]
        }
      }
    );
  })();
}


/**
 * 一番つぶやいていた話題（円グラフ）
 */
/* ハッシュタグ */
const tagArea = document.getElementById('tags');
if (tagArea) {
  (async function() {
    new Chart(
      tagArea,
      {
        type: 'pie',
        data: {
          labels: tagData.map(row => row.tag),
          datasets: [
            {
              label: 'つぶやいた回数',
              data: tagData.map(row => row.count),
              backgroundColor: miscBarColor
            }
          ]
        },
        options: {
          layout: {
            padding: {
              top: 0,
              bottom: 30
            }
          }
        }
      }
    );
  })();
}
/* カテゴリ */
const catArea = document.getElementById('cats');
if (catArea) {
  (async function() {
    new Chart(
      catArea,
      {
        type: 'pie',
        data: {
          labels: catData.map(row => row.cat),
          datasets: [
            {
              label: 'つぶやいた回数',
              data: catData.map(row => row.count),
              backgroundColor: miscBarColor
            }
          ]
        },
        options: {
          layout: {
            padding: {
              top: 0,
              bottom: 30
            }
          }
        }
      }
    );
  })();
}