<?php
  /**
   * てがろぐレポート
   * Parts & Tips / ヤマツ
   * https://parts-tips.com/tegalog-report
   * 
   * この部分の表示は消さないでください
   */

  //Twig
  require_once __DIR__. '/_modules/vendor/autoload.php';
  $loader = new \Twig\Loader\FilesystemLoader(__DIR__. '/_modules/tmpl');
  $twig = new \Twig\Environment($loader, []);
  $template = $twig->load('index.html.twig');

  //include
  require_once __DIR__. '/_modules/config.php';
  

  //default
  $results = [];

  //ファイルの存在チェック
  $logFileExists = file_exists($log_file);
  
  if ($logFileExists) {

    //ファイルの読み込み、当該データ年のみ配列化
    $data = [];
    preg_match_all('/<log>.*?<\/log>/s', file_get_contents($log_file), $matches);
    foreach ($matches[0] as $logs) {
      //<date>現在年 を含むものだけ
      if (preg_match("/<date>[^<]*{$dateY}[^<]*<\/date>/", $logs)) {
        $data[] = $logs;
      }
    }

    if (!empty($data)) {

      $total = count($data); //総カウント

      //日付抽出
      $pickup_date = [];
      foreach ($data as $log) {
        preg_match('/<date>(.+?)<\/date>/s', $log, $date_match);
        $pickup_date[] = $date_match[1];
      }

      //月毎カウント
      $date_list = [];
      $date_count = [];
      foreach ($pickup_date as $date) {
        $date_list[] = date('n月', strtotime($date));
      }
      $dates = array_reverse(array_count_values($date_list));
      foreach ($dates as $key => $value) {
        $date_count[] = [
          'date' => $key,
          'count' => $value
        ];
      }

      //一番カウントの多い月を抽出（同数最大もすべて抽出）
      $max_date = [];
      if (!empty($date_count)) {
        $max_count = max(array_column($date_count, 'count')); //最大値
        //最大値と同じカウントの月をすべて抽出
        foreach ($date_count as $item) {
          if ($item['count'] === $max_count) {
            $max_date[] = $item;
          }
        }
      }

      //ハッシュタグ抽出
      $pickup_tag = [];
      foreach ($data as $log) {
        //commentタグ内のテキストを取得
        preg_match('/<comment>(.*?)<\/comment>/s', $log, $matches);
        $commentText = $matches[1];

        //ハッシュタグを抽出（日本語・英数字・アンダースコア対応）
        preg_match_all('/#([A-Za-z0-9_\p{Han}\p{Hiragana}\p{Katakana}ー]+)/u', $commentText, $hashtags);

        foreach ($hashtags[1] as $hashtag) {
          $pickup_tag[] = $hashtag;
        }
      }
      
      //ハッシュタグ毎カウント
      $tag_count = [];
      $tags = array_count_values($pickup_tag);
      arsort($tags);
      foreach ($tags as $key => $value) {
        $tag_count[] = [
          'tag' => $key,
          'count' => $value
        ];
      }

      //一番カウントの多いハッシュタグを抽出（同数最大もすべて抽出）
      $max_tag = [];
      if (!empty($tag_count)) {
        $max_count = max(array_column($tag_count, 'count')); //最大値
        //最大値と同じカウントのハッシュタグをすべて抽出
        foreach ($tag_count as $item) {
          if ($item['count'] === $max_count) {
            $max_tag[] = $item;
          }
        }
      }

      //カテゴリ抽出
      $pickup_cat = [];
      foreach ($data as $log) {
        preg_match('/<cat>(.+?)<\/cat>/s', $log, $cat_match);
        if (count($cat_match) !== 0) {
          $cat_array = explode(',', $cat_match[1]);
          foreach ($cat_array as $cat) {
            $pickup_cat[] = $cat;
          }
        }
      }

      //カテゴリ名マッピングを作成
      $cat_name_map = [];
      preg_match_all('/<datum>(.*?)<\/datum>/u', file_get_contents($ini_file), $matches);
      foreach ($matches[1] as $datum) {
        preg_match('/<cat:id>(.*?)<\/cat:id>/u', $datum, $id_match);
        preg_match('/<cat:name>(.*?)<\/cat:name>/u', $datum, $name_match);
        if (!empty($id_match[1]) && !empty($name_match[1])) {
          $cat_name_map[$id_match[1]] = $name_match[1];
        }
      }

      //カテゴリ毎カウント＋名前紐付け
      $cat_count = [];
      $cats = array_count_values($pickup_cat);
      arsort($cats);
      foreach ($cats as $cat_id => $count) {
        $cat_count[] = [
          'id' => $cat_id,
          'cat' => $cat_name_map[$cat_id],
          'count' => $count
        ];
      }

      //一番カウントの多いカテゴリを抽出（同数最大もすべて抽出）
      $max_cat = [];
      if (!empty($cat_count)) {
        $max_count = max(array_column($cat_count, 'count')); //最大値
        //最大値と同じカウントのカテゴリをすべて抽出
        foreach ($cat_count as $item) {
          if ($item['count'] === $max_count) {
            $max_cat[] = $item;
          }
        }
      }
      
      //$resultsにセット
      $results[] = [
        'total' => $total,
        'dates' => $date_count,
        'maxDate' => $max_date,
        'datepostsBarColor' => $dateposts_barColor,
        'tags' => $tag_count,
        'maxTag' => $max_tag,
        'cats' => $cat_count,
        'maxCat' => $max_cat,
        'miscBarColor' => $misc_barColor
      ];

    }

  }
  
  //Twigに渡してレンダリング
  echo $template->render([
    'siteName' => $siteName,
    'siteURL' => $siteURL,
    'logFileExists' => $logFileExists,
    'nowYear' => $dateY,
    'results' => $results
  ]);
?>
